---

excalidraw-plugin: parsed
tags: [excalidraw]

---
==⚠  Switch to EXCALIDRAW VIEW in the MORE OPTIONS menu of this document. ⚠==


# Excalidraw Data

## Text Elements
什么是导数 ^s3PN95ss

· 指函数在某一点处变化的快慢,是一种变化率
· 定义： ^mnISkyhG

什么是微分 ^q7dyuwFN

· 是指函数在某一点处（趋近于无穷小）的变化量，是一种变化的量
· 定义： ^QNZwxv6Q

什么是连续 ^TZdG2jLA

· 从图像上看就是函数图像不间断，严格的数学语言就是：
  在一点上的极限值就等于它的函数值
· 定义： ^tGoe9or0

可导一定连续 ^74r8BRM7

因为根据导数定义：
当x和x0大小趋向于一致时，分母极限为0，如果导数极限想要存在，
则分子极限也需要为0.所以有这一点的Lim有f(x)=f(x0)，即
表示这一点连续； ^A5spL71E

若曲线光滑渐变 (可导) , 其必然没有断开 (连续)
但曲线没有断开 (连续) , 其不一定是光滑渐变的
(例如光进入另一介质的那种偏折)
 ^Se0Zmia6

连续不一定可导 ^ad0BOvO3

可导 ^sUy5tq0c

可微 ^SqqIq4WX

· dy = k * dx , 若有dy，就称可微 ^hHiRDBZR

因为微分当中：dy = k * dx
如果可导，则dy/dx = k
所以可导一定可微分 ^1mRESnLo

可导一定可微 ^G7Kn8JHG

因为微分当中：dy = k * dx
当微分存在时，dy存在，因此
· dy/dx = k 当中的k存在
所以可微一定可导 ^WgMPrtYn

可微一定可导 ^3gaDIqr2

因为微分当中：dy = k * dx
当微分存在时，dy存在，因此：dy/dx = k 中k存在
连续当中，如果dx趋向于0时，dy趋向于0，则表示连续
因为dy = k * dx中dx为无穷小，k为确定值，所以dy趋向于0
即可微一定可导 ^ouPmPVKY

可微一定连续 ^rLdHpBRg

连续存在时：dx趋向于0，dy趋向于0
即dy = 0，若dy值等0，就称连续
但
 ^CotkhqOy

连续不一定可微 ^PGDiPh7g

不能推出它们的比值为K ^5lUeCLi3

## Embedded Files
45e99a73a35c05d4524b3636b2f64b789b310751: [[Pasted Image 20240317184223_140.png]]

d833c4119c014ecbd6e165955ca2d191cc12f704: [[Pasted Image 20240317184357_159.png]]

db277e7bba95dbc8276dc57790e8b31263c03935: [[Pasted Image 20240317185201_062.png]]

06a9842cde37e23cd147e9d58e932109f6e9bea2: [[Pasted Image 20240317185216_070.png]]

086b1db918d3ea3c05cce14e5eea438068c6eba1: [[Pasted Image 20240317185813_303.png]]

fd19674c7a27ab5d3d957128a42d95f6996a5022: [[Pasted Image 20240317190959_919.png]]

cc8e8d71e16299cd9ec0e480ae069f509922e75f: [[Pasted Image 20240317192628_292.png]]

%%
## Drawing
```compressed-json
N4KAkARALgngDgUwgLgAQQQDwMYEMA2AlgCYBOuA7hADTgQBuCpAzoQPYB2KqATLZMzYBXUtiRoIACyhQ4zZAHoFAc0JRJQgEYA6bGwC2CgF7N6hbEcK4OCtptbErHALRY8RMpWdx8Q1TdIEfARcZgRmBShcZQUebQBObQBGGjoghH0EDihmbgBtcDBQMBLoeHF0QOwojmVg1JLIRhZ2LjQeJPj+UubWTgA5TjFuJKSAVgAWeNGxngBmbshCZgAR

dKgEYm4AMwIwxYgSbghmABVNAEcZU4BZUh4AaTGEAH0ANgAxAE1CZQBhD4NUrbQj4fAAZVg9Qkklw2A0gSBAigpDYAGsEAB1EjqEYHZgo9EISEwaHoYihSSbJEQVF+SQccK5NBJA5sOBwtQwEYABh5B2sdQq/MKkEw3GcPDeC1FEG5aGccwAHGNtGM5gB2eJzaY8eJvDUqmWNE6EjF/Nj4NikY4AYj5Dp5NM0cLRyjpHGIFqtNokKOszA5gWyNIo

OMk3HiEyV2mVPEmcz1SWjbwOVN+0m4PAmb1jc3zczePMTE2jSvxCGpaAmho1cwmSUNB3dwjgAEliMzUHkALoHD3ERnMLvFE2wRDcOaigC+B00wk9AFFgplsl2Co0iqLSkcJBcvnUYBiADIAJSESTmAC0jBN9HAJjxthMkaVxxUILhSKiqNvZ9vRxNXd0BgDgViVTRSAuJIjGmbZTw4AArIR+mcZgvkQ19IHfY4vx/CA/0WLdNyWLYJC+JVnCgHk/

gmD5jzeFYAHkAClCAANXwJiAHEAFV2MBIjsPKXDvzYX9N3/TdAJ3Mj0AACReKBMGYfp5K+bZ4nobjTzgTQACEHmwK0xiwsoJwkPDxIIyTRT7WUhDgCkNjkxtSySA162zMYRRNIgODRbgOCEMEDitbAMTk3Z8H2WVCE9LBcKdA5tnITIOyCkL8EKKTiLfES/SwKAaV6VpuCVXyeiYPoOEGDhhjQMYlTebM3nVA5ljWYIXJ2PYEA6uSTjmAAFfp4jG

YcaRBMESTJKQ4QRJB8TNLFwzxWUCVRDFZo/QQPBpOllAZJl1pNdlOVgXlKsgQUyWuiBxQVeZU1leVUEVMZVR5NqWrGZatoQb1rTtR0+WdV0WyET0gd9dB/Q4QMvyyYqDjDYhcRZCZ7vTI7irQOY/o2ytXLeLG3nJiY5nuyH207fJ7JNAchy7YLQtlecoeIZcMmR9cGdKRznKrVA3IbTzHwmHywviwK0FZ/AwrYCLhei2KTW2TgoHBQgjAqHhy1lD

Xsg+XB9FBN7WVlDZMDx9BAAG5QAJOUAejNAB/tQAHUwOyhTiK45Hddj2DmtqAAEEiGUNp0GCbYUdlZooHMAhQ9+CPoHZGk9GyXB4qYDK5aytlSF+eKCG9m3fed92aVwIQoDYU9wh1ioUSEfrZX8hB5IQDNbaSbR4w6hLHvQXAUhStKEFz1B5Zy7pAPMj8g5K6qypZZUDlKgYhgqDz63JnlJg1DrVnWFW+oG459A4NtwTRGBJG4qbQQhKEP1heERC

WjaVuxdGIxZf6iQ7WOHtI4/ZhBHWZqdUo51sBciugKWod0DhD0lPWA4b1JTjT7j9fuX8AYwxBqDcGEVIbQ0tMDP05AEZBmRqGNa1YeS92VA6Ms+ski4JNDjTMjV7phGFuMHgPINQtUYQbE0NMOx8zAZzSBec2Ymg5kuFcvN6YHEFrgHqLINTuXFt5e6/lZZT3zm3JWkVeoxVburTW2tdZZnukbKAJszb4AtoHH2EgADtqBADgxoAX8U3aAAp1QAC

+aAAA5QAnQ6ABBNQAG8qADRlQAIW6AGv9QARobUCdiEwAs56xMAOHOAAdDgXjABZ2oASTlABY/57CgpdbYQC8X4wJoTImxMSSktJmSYm5PyagYpZS3E2yTuHY4UcY4mjjgnfAfSU61zgOnTWWdGSkEnvLAuRcOAl3cegGp/jgnhOifE5JqSMnZLyYU0pVca51wbrYtAzdLGlHbp3buIw+6EyAoPXCPAprjwWVlGehQ544QkIQfQ0RP7DOXpwEYGp

nlVRaJveq28NRCKamMDUdYj5dQQJo1AqsbmkWOG2YO9BEIm0IBQfSFBo5XnkkkLEFBSDbHwI/GaL9jhv0WjSTaRIf4YxFgA7azKJAgK2NIiBJ1/6yhgXAlkfIEFCm4PdFBPB5joIlPMGMUoxi/V5YDchsNoBUMRsGIZpQXQkIHAQyhAYaEhlRvQ3gRY0xd1xtwe1RN+H6gqjyeYa9ZQSLpmgXs0jPSyKMfI41C4ubKLXKohyTkNH8O0WLOsEspZt

xlplUNkBwpmLQNi5aGihBdggIgT08VlCMonoNSWCB4jxFwHWXABNsD72IJLbMmhCyFk0E+UmmhDTxHbUkRFo8NruAqBuRoltNxJDsgPYgiVLJzA+abCt6aFaymwKiKZcjsolFyn8gqlQEDVFuiC6FNVuBTAmOvMFtUt7cC1EqDUeouhxWPt1U+Fjz4SBWDAHgzh+hKnYv8BAcBRhwHiMoTiCB6BfEZc/Ukr8Fof3Zd/W1k7Sgcr5Qh44FJmBUiFb

KQ6x1JpirOhyWBl0pX3RPXK5B3BPqqhVOMZF9Z9QEz4K9LMjZtCPuVF5KmpNvUmkw9qn0hDHTELdGanVxx4YGtoTa3+zrSzYMLKWXUDZtQOoefjHMCQNRJAqtGWY0pxoVmFoIpUgjJiDubHSWmUjCPhuDTJeek4ZxznDdzVcOR8gAW3Li8ilFqK0XooxViHEuJ8QEmZf5w8xISUaLlEoMlAsKSUipNSGktI6T0oZYybBTJCTc5ZBLNkktEVS4cQa

4I4DyX0CxXSgN6DEHBGMfouBRr6DGB8B+xW4ufjK4RfzJFqvHAAIovBuJgB4ygeuwI+PJLQ+4JgrFwKeMt/WD2Dfwn+GdMahauQTR5JNejpYBVXYrZWUUz5xVeZZF8Y9l1fLBD8lLVttuL2vTCiOhYX2gp+3VBqItmP5gRZqNFJ8bufrioNC4GpiAwCEBQD4/Q4NAJhEhxEWquV/x5XgwB/L0CCoOuA4jXZ0OQAlZRkW0rZQ0bQPK+jVmeNjGY0m

tjsxlXtBrNoIRfHHwCcptorV5r0D2iIXOCG0mxMWuoUja1so0bcuTNjR13DUAE3M3JMY8ReM1mpvZyR0bGbOdFSGtdCivORt8/6/mkB1GYtFidrykt9Fpu3Vd7NWLbtWOyDYvWYjgSaycebKB2E1kQD9oAOv1ABgSuUyp5cnZx5pEHcZAyEDRyXqQeO7h09+jTgcDOURs7zLkos8Vhd/CrLLhIGP8eBRnPrqwS5qBrnnY7urnuTzZ3zuHkVw2nzy

/fN3bPD7Fk4Y+2++e6s7Dp+tCB9vHgBn4xKhmJD990O1ayQm/0K8FBMD0DeON9HRP5rv2xwTjEuPw+mgBhj4nlpQFOfpMGynEBqcWzpyaBnqAmeNSVDmASEYUbHzDeFGFJn+1KDegEx4zrEAMF2+kpiD2RHwRkwkAlwkyl1NXDTFz1UtQVyNUgGVzx111zHmBrXiE9XrE1ChUgC4VthTWE2JghWamEWVFsx9SNz9W7Ht1pDNxIwt0805m8xUTtzU

VjSd2O10Td3O0MQrz8lMQ/W30gAcQDzsRShD1NjD1IzfEjy8SdlqS2UiUAAh/wAaNjABF+MADi5QAA9NAB3L0AHgdQASH+4lYlAB5xMABh/lpRpNwo5TpE5fsL2fQ1AQwzZepCJcw6w+w5w1wmJTw7w+JXwjpLpVPIqfPSOTPIghgJgXPROMOCZQvddGZUvF7S3aBKvYufARPTxEIow8IyI2wxwlw9wrwg5RIvwlIxvWuZvRubgdvVNRke5J1FkH

vO7OdIeT8N4JddKYfV7UfX5cfD8QFYFbPGfTXSmefWFYHBjRVSFNqDfDFZQnFMbCQJUOAL4KAfScbJURCCYQgMYI/eIFiK8YafAfSKAY8U/bDTHC/U9VAzlNDLVB/CAXDfDUnV/c3d/T/eBenRBYUOjNAIsXuJUUsPtQzUmSFKAyAGAtqbQPtYRXYqzRscYUXdAuGfVK1LIk1KTXAsk/A+XQ1OhJTRqZMbTYYu1bXC9N4R9LGGtQ3VsY3cQl/INc

3BQsNEQm3RzE0R3eNHRU7WQgY+Q4xRQ67cxFQ00fNQtYtRwWoctSeEEwAuYbABsToJtZMI9TQYgN4BADyXXT6PAHgYgToJIbAbAdhbYBFR7EdAgMdbcSnMAadRoPg+KcY3CDUaYldT3ddTdVdN7PKYSCfWkI9GoWVTY37S8NMxfe9bUZqKmSFA4zFXNWHY4feFieEFYOAKACgYgTEAADQ1AoEXH6DGAeA0UxC+LmlZWQxx0BKv2JDP1BOpGFXJ1v

2hKoxlSQVlBQWmF7i1B5HiHjG0SRRrG514HnLxPJj1wPkbARRalJNl3F1BmSnZml1pIPPpPk0VxNBIOdT1z5x5CmE9RRO1G0UPllAYKzHVDxP1EVRrEpj1zM1dTkkpg8j1xag43EW4KlNKCZnN1cziynAq3Zmtx5ijX9RG03BOPQH3EPBPHPEvBvDvAfCfC9NGwGyskS3mOkgCywrlDAggighgjggQmQlQnQkwi20TIovKyosaCq2AggFq3q0a0Q

D+Bazaw6y6x6z6xovIqG0kkqxooEsm2m1m3m0IEW2Wy+FW3W021ku224r2yDIkMOwhTlNdyYNuQ9yEJMVVJzV9x3Hu2HiVAjNKLjP3UTK+1jhvSzHAMzLvTQGahakNAbGNB3DfUOK32OIEtOCvGIG4h4EQmPGDg7MQ1+JQwBhv10P+KwzmhJ2HLfzZHI0lVp2ozhNoynIlCVBRO/PnMXMlhVBXM43aGVASE3MaoMxRW+jfOExWjwMwIdEk1IS9Dp

Lk0pKZJVyxjZI1y1yApGEfN3lETswFJ4IDWFMHFFOVPFKUVQtt14JMrjSO3MuTXdwuyjJVO9yLL9y1l6PaBQIgAcVDxcVv0Xjr2dkAD34wAW78E9I8/YvrUjel8iM8s9vtcixkgaC8pki9ii5lSillq8qjfqPrvqujzkW8m5SAW4O8hiNde4OFHLQzLJ4hXLZid0wA91FjZMp9vKftJwPJ/K4VJxnoPUDQCyjiv04ZuI2Bq1rRjz1Yn5gSuzL9er

MreyRbCdvjH99oCrISiqLov8yrZVGcET3pqq4g5yFzkUGqD5Vy9QYxhE3gtyawdzvp9yKFDzJcTycDOY8CxrCCJrSCPI+4dQ+T5hhc6CpAu970Pa+FXIXzph94pRlrHJBT9r1rg0xTIBFEI1droKHdJDZTE0LLTqlSM0IAs12bDZrFbq1zNDjZtDnrsroBgjAA5uUAD+1QAeYVAAoOUAGh3QARh0nZ/FK7ABYOUABfUwAWtMPDABSOUAB4LOJN2Q

AM21ABb6MAAAohukpPJVAVAAJcJKuuJQAQPNAAFNMAB4FOuwASW8rDABg7TiX8WXo6ICMIyCNr3WVQHLurvrsbrdhbo7u7r7sHtHvHsnuntnoXpXvXq3p3rdj3uSIPrHDSIhoyJBpprBvSNTihqKMzhKNJvhsqOqJPrPtrobqborrbs7t7v7uHrHqdgno4CnpnrCTnqXtXo3u3t3v3u6XpybwuQxqxoGM7x0xFlGJeUJuHhSqexmNjN4o8qWKBWU

D+OyNpsxggrPQXwCpFjFniG0XGh6vCvRULIcrSwgG4nG2DmrPJQoExCYgmGUHkmPHOLYDmAQDRCvFSpZSx34ZEyyvx3Ftyo/EHII1NwhMEKhOKpp0HUVsnJNBQUfUY3zGzC1EvEvGqtXI4J43cj1ATX1HAJ9r6tGopPtuwJpJtriYIMZMU25REWmttjmHf19udWTHGEMwRWDocxNxgoEJZi2qjpQp8zjogBlKOqTpOrkMu1ssuoUY1KgALWOG1NL

T1MGmIC7RRQQA1E0BdHGkGewCs2EWIGwGRTnIQAghyalCNOLG1AH2E1HT8ynSIkDJKGDKcs/H0hJtaZNA3TTm3XcspoBV4f4Y3gjkvCvRppqizMxn/KLB1tfTkczqAkGnYjeFrMXGUD8GUdOAmGIEQlIBWHwEkDYEIGcHoFMZ+LZR7OZOsYwxWmBPsfBJFWcbloowVonPhMqoVEfTiE1H1ECeFyVH1FXIbBjA1WjAM1mEhWzCxLvyJFtvibSatqS

bIXPLtp5evNtUliec4S9vaB9pYMaijCCqDq4JWrqdgsEMjogGjtELQrDulITsaZd2acVNOduSUKirzS6a1KyB1L0v5uCH1O+lwD10fGwDnU1AQHmCdeTA1GrWICamrUTEHXiG2GtP7RCHeXxC2fQp2b9P22Yb70/D+BOfOtKHOa3QtyubHAMrKzTMnFLAZu2MfAqlGEYTZpNeLL3APBcTwovGvFvHvEfGfCRfQCFosdQzRbFYxfvzP3ypf1xYp3x

ZKvcaJYqq8ZVSpmdsaqmEfWqvJjCuxIlHYRjE1ARU+gbFEW5LbZytE3NogAGrBkSeGq5dSYUyV1tQJiANmFGFRIfP1msyybpv1sphwQfMTFNrmrQGZc1BzCoJKdDrWscZFMEPgoPR4A82QolNjrKfjtMq0WOrOwNcTczWNbVOOIJC/EuJDL6bQFc3SB831LOEuGuDuEeGeHeG+F+ABFfAgGUFwBTcHR42XwPm5M9P1i523AeqVm6cZ20BrAqnjEE

SLHnPrHGBA5NAtf0nQ91Mw9Y+w+RltbGDLMkArKrJrPrMbObNbKgHbKIko+o5GESCxmLBRINHYO5JQNUPY67GcB5FjG0UvCM/AOqsALeGE9uVCCgAtH0DNhkE2GGjhZDHg41Jz2DgSypFwGgdlAtaC5/BC8Gm4oODgF872vHRKCS5KGulS+3HtzABS7AA+jPY6GTAN3zZvYCxyfvcLA1UEUpj44y+jYJtjdwBWATdTa4eucnzLizcaimuedEcZql

R1GRXYRncOAivkZh1+eOG0VICVH0lPBuHDJSgFrPybYyoBLRdycxc7afwcfKacd7fFVccJdhKVr/xVucBpcSEHTXyZfFnzOaveku7VELHYQfKs2fQzL7P6qPKGply3cFaPeFbW+5Nvfxilf4T1GVCxnYRekgsVYg/4JkU2rTvVclLh4abMqadg78mstVYzpLeuvULurzscQLtcStkj0AHvlF2EJApf6wIipCnqnmnlGsnwG5OYGrIkZPPABsB6ZS

B2GsLs6ColZRG4+iASn6n2nyh7o6hvozG44u5CVxh/GpYQ53ARcJr6eFr9Nzy6mgHNY8aD2+515kWXXbMKzD54tpDjmiAYOCaOAY8AzdXhbplSW8/FFvsqx9bjt13rtxxnt0cg7mEn/cq5Wkl1WmtPuL1Kg5fOc4R2dhUUmPnDoNfAmUscAqYaH9tzlukndvm41U85JgV7l/70oG86sR9BISgw26MbMDodlj8wK3haV1AHyJNDVNBBVkO1avg5Vy

ppHmpsQrVgWHV9HvVzHqys6myi6n54Pf3HO+mrO/O5xUnv+0XwAA7VAAuOUAE4LQAO2N3Yuk8lABlfUwEABiVTAHkQAck0HCzDABEFSsJCUABfAwAN9MPDY9ABZ6yXo355A8MACDNQAHPN3YS9QAM8GgAQMjAAGtoBIPCeSQAJhKseQAAraS9QAPpygAAHSQBX/bQIAAEjQAKdygASHNAAm/HhI4kx4QFDgO2AAAKTAAAEoAAvOQPP6UCPCgAZ2U

8kgACwjAAXJ4ECwkX1QANj/P1dftvz35uwD+HAY/mf0v7X87+j/F/u/0/7f9/+gAxeqAIgFQCOAsAhAYvRQFoCrO2A/AYQOIH6BSBFAmgXQJ5AMDmBHAdgZwJ4EA0Q43PQZNnhAbc9JkvPEvPz0NZU4heNeKpJv13779SkR/U/ufyv6397+z/V/h/0Xpf9f+AAt2MAPAGQCYB8ApAagPQE6DOBRAkgXQOMEUDTBTA1gRwPCTWDUaPRVvP0Sx6DFF

eeND2iGXq6CRB8z2Ummm3yiJllifDVYivF4DK8BGLzMRsxiQLIpAKQEEbjP0UZohMAHATAExDbBzBjw2wY8J1meLMAYAGoZQKcDYAuVne8GTsuYxW7X4RWQJTbtLW7Yjki6Y5UqoO1D7DsFQkKDUHzlRJ7x9QswaMKuWcDSg4CHaGliZ0TC3cbGm7XVH9yvL59ra/LX7sX0BHEE0M+YHjI2GlCdAUSAnd/A3xFiJBGENnJ9lqBrCahM+AgZvoIh5

A0txgpMbEZRygpw9e+7gtVgP01a/th+UHEWNIXlKWVM02PKpunUQ72UxuGLTUj0wtZ9NnekZdAPiLeCaAkggzaYEqGICGMG0TaMYK6RtITAEAzwEIMgW+hKhsA1pF0MOk2Y+ltmE6XZrVxV4sNPwMldWEPgpHJtOG5NMfNrw/Cxduu4KXTOu26E9dgc3Jb6J0CxjVDhhePHfBIFAjgRII0EWCEkHghIQUIaEDCA2zd7dkPe+wvssCV947d/epwwP

uOSO6eNSgKCfTtoBajgFiwowcaPmw9oWwFyaoX8oSLZx8hACZtXVLn2+5nlQRh7cERADL6a5EwCQK7kKPT5s4USwPTXPiK44PlwCRYHMJ6ih6ckWQy+ZUG1ELHftu+gaDagB1Y5xZgOSFK3GB1qao8R+0HDHgqXKGp0yiCHOyj7k5HIhUOYnEtBJ1QBYcbcsneTop2rJ1kGyTZFsm2Qo5UcaOtw7MJLENpWYhELUMHFpw1jYAOOf+PnLZxnE5N2E

0jPkAaGc6QBRO4nMtJJ0wrSdsguHc4FcCgC3B7gTwV4J8B+D/A6hmFD8VmCAKJhswnqBFIqhOx0EzOIErsFZ06DkxuS57T6B62HHwT06rndzp5xcg+d4otsVVih0C7BcQgAvUoBFzEmhdRI+EOLgl3XDbhsuaXMADyAy5ERsufjDsariCrJgex67EoIqAHFYwcwHkIcWOKlA1djKYxervJA14j4rRCxG0ccFSjExyAVADri33upG9ehkjUsGzjaj

v5OoUOK3qW3QCLhxsMAD4IQFPDKRmA7ETADAHiBsB6AcwXiFAH0BthiamwwWjsNRbco4+HLWxsAi244sTh6LKnKmPOHpjiWVw96FKFuEUxW+/jJ9PdQtiqh2EbOB9uxisy657qImT7pbQUQF8QR/wsEVkVbHtjJGeoDoAaHGBahkUfYlFH3B45MY7OksIbnk0nGUx2MqfOcUqwqYUjke4HIUtqzpHO4ZCTI9OiyLTq49QpJoeLoJMUmbhlJQkNSZ

uEy7Zde4xYB8gZ09TM18w/pMAHEG+j4j/xD5TEU+kQrWSXpAWCYMkFmkCJ8RUYBNNiJKC5hDMtfNhF5AgLxB1JSkgLBjKsyPhsZj4UYOOICyXhYw40Nlo+CoIBMn0+M2GSRESBTjpQJMxhDkyfRozgZvcaUCiQfSfttESBJmY0C+mqgfx+8cHATFmCAFTOYAesPeT8YHwOC7Mpzh9I0mUzEg8zA0L+XjB8h9YBksAI+D7g5gGMBIgzOwgmCizkuA

WRVDmJM6OcpgHQZGfLJ8hccaWhoaUPOSLDgFoZ+zTWSRClC1UJ2KoNfE1HrBGzdcG5LyIHUkaahmoNsrLnbMSDVViSnqUmM1BpaLTCZuYSRi1GNobTxoC5JOZpN7hRh4wjYZqNqEfAAShI2iZIDS35zCJB06oEuRrIJkkQppT6BcidnmnSN65X41aQFJRSkx1QpckrnEGmm9y5pAwnOSRGESmy9cKfNqCy1JgTyu55cx8Gzi9k1ypQSqALA3MMz0

ysRrcnUKuJhliySuVnXUBe26qtytQ9c+GcfObl5i25F8gOZ3M3Cjtb5quOaVLKxIlAj5TcusC3P3jnyrJn8vyDxIMB8TvOCXCkawH0AhQ40w0QIMOGQxXI5ecXdBcwA/h1MahExXAG2HslzFHJ72ZyRIFcmbB3J7Qh0agD3L2jb0vXEWPrGnGnshuwUzfPdN9HoA3gfgTEGiA4CnBnA0gRCExFICnA/g+AAmKiBMY5SlueU2MWi0KkiYExpUmWni

327y0g+pQX/P/nehUwgCrU0mMWClCiJCpb0L8vrPxEgUjMpmGseJkGp7sfuY0psRNLQxCJkg4BGtAmBWasY+xrMusOzMVSczGw8rZgsLCfRCiCYzUfaWSMOn+djpm406bSMOqj9LpKdCkXdI5HqlHp1Ir+Y0BUnvTL5tskiN9KphYxmEiqP7DmHlklKoFV8oOXziLAVRhEEM0BfUo3mbgiZWMlPmTMVQ8znAFS36dUoBk5NulE6clpnJ/FSgUSUf

ISMMr5yVK/pNS7koDMmUlBOgaoUeU+lr4+Q1m8spZT9KqU8dxlezRpWUs3D6xWcl4JArmL9bZhFlIy05f9MLCGkLlYAT6SVwu6fRI5xmB0FqCGUgzWl4M1EpqHmCbKwA7s6MJI1zI+z3RgCnLkAXnLsI75/8z6NKChXgE6OJM/pfl2r6LKOpswRhFQXJnzKtQUKgzHzjhUASEwlMR8Ist6V4rHm+XKHlSqHlPkR5wiDaYsq/HzspQ0TNqB6njBQq

WcVXSpVXNlZaYAszgflde3JgViRVYwMVbmD+XTAcyfaaUDI0aByq+4AqxVRqiagGyVVHc5mZuBpY5jJYdyjEb7MfR8r9VCqoVcas9SmrSlyclmerQ7QczAm2iI5WqglUPkpV0YQsFCqwTTM/loKthIsoDWJhJVfaENerPdXZc7y4o4RD5A9bTjFlQS71aEt9WWSzVTSqdA+T5wIoQqrqhcs+mzV9xglXkQRPmqTWXKPVxa24R5E6CFjEw0oAJbKp

zUhL61XMgtcmspleK21viqrl2qmDVq2ZdasJdzMgVfKwoMCjzmoH4kIL/OSClBRsDQVMhMFbebBbKDgC4L8FcPQhbhBYikKyaFNShW1w54+UWQ9qphcb2gn1geSuuS3rkuio1YEAPIK8GbFwBTEFFrvZbvlLxyqKNuPvDRccMKraKCWuim6CHxO5h9hlmoMsdqGXyCJl5vHXWkAUfJSgZyTUTqk6IGk58vuLihsW4oZIl8IRaLF9X3CESSMe5zsz

oH2IqgTiGF8IiiV+076lNUlkAckUkqpGJc+CaPHcWPz3ET8DxXuEYWxzn6t4F+11J6ivz0Ki9AAp0GAAns0AD9foAElFQAIt2gABDsokqAMgZT0oGoBqAqAQAG6KgAUf1AAbI6ABCmxwHt1AAAPpGavqlAvJIADF5TTQ5uc2ubPqpm8zRZubrU8nYumgzXEjyRkDAA0fI/8tNgAbfjAApoqAAz5RCSABpuUAAUsXEkADFCekkADyCoAAyjdzVwDp

5wMIA6m7TfpsM3GaXYAWyzbZp80uayBbmzzd5sc2Na3NZmyzcFoKShbKtEWjgNFti2JaUtGW7LXlsK15IbBoDewaDVGSgNnB0NPnjnAkkeDlkXg44OVrC1VaTNnW6zfZra1+aitXmjTQ1sO27butvW8LZFpi3xbktaWzLTloK1FbTk0vdGrL1oblD6G7JKob3iIUPAL1TQhMgvF14iN6FbUQqT5JYXtqZZyYCHF8xCkfrreoXHkPpCYj0AmIi6QD

dsPSogbb8aiw4c/j97lSXGOitMcH2O4GLkNiQHJvmMVXqoSSd3SUEwm/FdTCwHzKMI4owKkbeW+7FJpRubGtjmJfY2apEtciUT8wKJKmPEt43w9/2ffQ8ZSI3GD8aRkHdJaJsyUtN/OOSk8eqTUI519YRPRTS9UjxfVutlPPgVUlN3U9zdPSWwWzwkAzbgGc2pwYUTOYw1ltFI60GtpF6W7PqZul2C9rRo50yhE/L7bjSYZ1ciFnxdhgKM17kL4y

JWSONnDoURwRcj63yQE2MxNUhh3zH0Yow+BCBtgtZUgEYCVD0A2wp4eIBC30iYghAQgbAAZA8mGxFuQGpRb8KsZgbveeVSDUTug1kZSd1U8nRmLFBkS4gnQQ0JUuEQFtCwLwxMPrQNA7zPhswZfJzotpYEedri2TONIdpyo8SKob6OhsZb2dnh75SoSbLTlixuquuFfGxqrkqgtQetaXUPz42JLrxy4oDlxOSXK7hN24+kTB3E3MjJ+OPdkTruQ5

RAc8F4y1hSMQmXjkJU/FzgSF4krr4FgkxBeAZDjSSVtGAT0JF3EjRcKR+SxLoUtS5vSoVVnQ0D5GCrxgiRhmE/eUvP1XczJC+yRuwnnUHMjRuAG4ADq17NDgd7XJhSMB1C5sKgH7HMGzqCneieFijZgLxBgBjAoAFwHkNgCjHAblFKuA4RBqOG97ZaMG/tt/j0UIaDFKzLjgikrX4i2c6oSxRKA7Q5iKCHzXMoAXZbEbzydYsjYX0bH86PFaLDVM

LtB5yRDV6JCJaUF9QHSEeKrVkV/upE/7zpDI5OprvgNHj2mp4mTTdVbwG7F+xPZfsbtF427D69PHIwHtt3TbMiDg53fbrhiu6k27usvJ7s8E+7jguRn/FQze1YKPtoenGt3i6GnrLIaOGPW5R4NA7jgrQu5neq8nCHJwq85MNMC9G56pDtFegPEG4jo79IwcR9DAHYhQBFwmAdiMwEmw8h2IjXLHWlXd7t7bUneiWt3q0NJjidfbNxvofg0U6Vag

qnZaZm5kVQmoVhhUFBLLEExiwksAKXrlX0Xlxqbh0aVvvcU778YtLU/Qw3JhsbswmoZMFdyf0q7Zdi4+XcIR2opLn99TX/RdMZFZKtdIBq6lyLNY8jYD/TFyU6X1DaJsAGoXAMvlwCaAxgko4gNI3na4BHwbJsYIGxrRvBcAPkRVOynDbdg/S+o0pYcFV5MQL1ReGMpcwGOJ7rpjIFPSMFZLp6WFpYCqJQR1XDdZjiOsKRAFPBrZho+gIwMeFOCS

BTwJgN4PJGcD6QxgHEU4OA2tZbDjjMY04yoo0OXHCd1xvvdAiqkDsapQ7TMczlzDVUQCbkR9FuTpajsdQdYIRHqA1S2KgTrhjfeRvBOeHITLfbMFxyCYFgZZa+e6kiO+k+QFyNM5FIMqFG37wCeyjoIyu40/se+r+wDhPg/nJZFdWJ7/QdSkL/6rpBibJcSY6YiS0OFJ/zjAagNa6l1cC4gAJL84JGAuGBqLuJOgM4HMDBBhSbqKuVFLSDharcyU

CeG5m+MBYT6IWeeV85SziZxcpWcTkfSDRkpjg8NG4Px7uGVNfg3rw6G8lxjPCOsDk0CnvrQD1vcEBcAuBtgLgEwOsiobb1Z89ha3L07tB72+mdD/e2DWToMOPGw+BG7BHyHVCzA2cgnOlkWBWmzSdEmK/qbExcPc7hpwIkakXwhPpNSCxIpESLowzN9/W+YUs2nph5d9Qjcuo6YJrqYia/9u4vszdIV3a6STZnWTYHkN0k9sjVScntHgt0NHFLRR

uwSUdm1c9yjPPRba4I93+cvdCNUrQpcD0lCaG8vbOB0ceRdHVeJ+Po40IVMDYvK75+hTWHZaQ7gctpKsU+hRT/mJLtFSQPJBikrB9IV4U8JBZx1qG8cXvC4/BauMv7duAfAfYGaH21SQzMrWcvvA0z3Cfh0BejMZMMxCj947CbREEY3aDT19VFvljRY8OXkvD3KLmQkHbXJ8cr9BRXl0K2moAFyhnJ8sSJCMJKwjGJ0Dp2aiPdnE6YmkS0AdZHiW

OmeutI/Yi0JZGi6r1E+ojlQDUDUAaIVAAACpUAxATAJ1pU04DEcHhOuoAAfPYyyVuCKrX1rm1na3tYOtHWYAJ186ypZZ527+kDu9S07s0sfWKjzpqo0tpqP6W6jpWrxNdY2vbXdr+18zYdeOtnWLrUvIPaUP3WfbLLIxayxwbCt2XLRV63g7JOsieT6OX5kHFGFLAfsdTXCyKnMYEoUQqINEOiAxGYhsROIPEfiMROBAt7sdJx6C6tFbZwWSpcV+

HsmIqkf4Az9xz8IYZVqG0rOeZR8F7Khlr4Xh87BIM+w/aahVRkjFM5RaBFVWD2mZ+ixMZBWcyNU5avMsLuXw5js51c8YATE9K37EwPkAKYZhRNNmBr3AFs3rE/38WtxMR3s4SfnPTXkjw5yAxhzf2oTbxg0PDlhJwlEd8JpHIie+J04sgmEvc76ABKXI0sgJ5nCUFZwTDLNJgcrKgtVS4njnQ7N43avqR/R/oAMQGP4CBjAwQYoMMGROzRwu4eRD

ZrLGWcIizsMTd9kKGWVQcl2jAOgXE/AFOeQMzm11854c7gYoD4Gxzq5pczJNKxySD1G5iNkWu3MBYGlC64gwrJagtLjbBoDjUIiEjfDLb40a2zhc9JsHftuEcEE+dxuDHCob50Hb9iExv2n1p7aCdqE4WSH9T43CQEkH0CnhFw4IDgMeDYDhXubG7DvfzYFQIX4rwtknShcH1oXh9D0SMPbNLA1giRj5J0Rglo6itTJ7OjVSx1+HlXnFaZ9wxRtq

tZnKuthnUIXJlnZ7SgSIl1KLs/LsWSrLthcRHQiPe2Zdgl/E3Ebg4B3BzyR2a9vGJGPVZLS1yPJvzjyH9AAtHIlJwbt1qG3kn/6U8PC0AxHAoHus3W8k2A8XgUgUsN48jpWxR7HhUdqOYAa1iG3dcwBaO/+OjvRzAAMf7WjHHAEx4z3MdTa1LQDAHI4K0sLaIGuloG/OYMuwMFHG/JR6o/UeQ29rLjtx/o8McbXjHWA0x/4+KEy9Wj5lioQwx+02

SiFpwR+9aLxsv3b1gjVAHWAh03on1dfFEp0APk56EdAFg09xA1APAOASoFiPJBNEc2XeXN90zzc97wOpaPppBzcd0N3GPGqVkfWgAXJWdp2KKJ4cFVGAvDPo2CcUR0CaiftGFFDkjUNJ1u87aL+t49oDyLOK9mLOI/hN9HrAPPimDZ+ceHUR4K7IjQm0a7qw11iPgDx4vy1I6zD3VZHi1kW8tbF5+PXrjMI+vJahcBOtLju4J2Ud+vaXwnsyPS1E

5BsM9rd0LvRc0eD0o32jlQiPYaPq68RynTkyp/FlXvOWI4tfYm6MFPZ8cOgvljpgJUUhxSssmkbSLpAMhGQTI0D0Z7A7jG/D1FgtojH6cqlJXxb+ilWvqHhn8c05kwUm35Tu7j6Oxn0fWHOV5IM6jnFFk51HRGnVXaHIJy5/VfJgJAWWM5NtYy3Nvlz0+3JNjJiNUWsWqYs0xjbw7edLjMKK4r20rpGsHY1dQl8a/7f+dJH1SwdpCe7ak4R3jgVd

/9IBmAygYkg4GSDMEGbtadSJLIVOdVSpiTAsYbtVFKx2AmgTc7VBNnP6wrkEqNQJdz0CHavHl2cOkdzCQR1wnEcCJZHdm8EaTsm9I+hd7MLaUNp0S2OvdhUDLafQeRhxnog2XjLXEIG3OsCie7OaEmsiZ7a5he8QFnvz2aXBNte09M3PNqt7JEHe98pIiKhLXNMgJhAUJFGzFQHQNqsmCdfsy6nt9kp7hHYiUuKF1L4uq/aaCjHow90dy9vFrk19

JG7LSm6N3VICVMQygG4GgqgBfBitze4Z26eFpjOzjEzk4Ig6FszPkLeh+Z8GcWct9kwjcz1OKO1A1ouhb0J9ErM8hsJLuLVoqX8KcW7tqHYJuXHQ4NvtABxRYB9GPNJXtQYT7JVja+xb6uqQqcJl5zxfRN8WA3XzoNz2eEthuprEj3XdnTk0yOFrOhcF7E/id2OHHGj5JyILjwQCX+iOZQWv0AAm1n4TSdeOIbKjuJGiAgGZOFL1uwo5Y7082OEn

9jm60k+ccmfY8ZnjwhZ8gHWfbPHj9J5tcc/OeAkrn6PO54ReoukX0KEJ6i7Cdu7AbcNSvN7qsdxPvPBnvz046P6meAk5nmAJZ5s8dI7Phn1ADF5c8+OsnCXsxx56aOvbCXbRwA2Hs6PVDVemneoRw3lPPnWuv76p2sSBXE2US9LPXHDrafcKAHvCiAHMCo4rBQL9wIV+h5FewX4xBO7btM6lei2ZXhHy4WlZI/ksa07rqYOwlVS61W11VK9/rFhH

4itbhrtVsa71tcfzXUVoHsJ5mp+HdONLKb9xy9d/tZPAm+TwJbxOxH9W+4gcwC5msafpLGRo3fI5yPNfGjMFWF8pcS+qXEXX15Fz9YKL/XIAxeDF5E9VbRPheRl9H61/xftfkbnXpU916su9eODtZL9wnrkq0u37F6Q3g096HKhJgjCKiWy+SMCUhKDWJrGJVaztZOs/QbrL1g2/NtRafNnb5oame4eDvZw5K+g4WeYPOuVneMIgUA9CJJ1d3MHL

GEyt6gTJmenU84a3apnKrZzmq2a4B7cp4CaoaYK5axGFuPaxZoAiiRVDR8+MiKfYmJ4w2vdwCnBLizxpxP8aw716ts5iZjrYnUTwj6H+P0AOSa2m0mqN6OYT+SS4336X9Im9rv13U3jdjN7Bh7tlvsETUY+UaDXwtRqxrHbN32+v2drq5SZ/MNbPncIT630blCSJyL+Ci5O5ZSso+JU4vj1O/XzCqW4s5MSM1WctPnMqlDybxEvb8YFxyZbCy+QA

iPWqPfHtedJ7qB9dege3fLnN3F/5e7u6b0PT17op81ce83CnvA5m4OVa1V1wesXypi5XoZKpmB+uuNQSAEofm6r7Md5t0bDw1fgN6x6Dkk/aKmdonS70YfPoDhiM1mB0CQo1+qL7Qeg0CpQzYc2B8ALYS2JcDaUa2BthK+uwrzbcoRGuBreme3pr5IW/pkd4XCiGnVKSg+8NgjjApYIwgF2errlb4wLODkwQ8wiA/rTAL3hVanOm+px6u+pfLaja

IuYO1TM0lmMxq/etsIIh4krUkaBa04BHqDwm/4gWylghUn1Yy68fh7ZZg/rsNYKeZ0sG4iOMPhJpw+EbmAbnig/gX4ISI/hAClk4/kpxPiqnK+IacFHPP676a/vWAooU7KrjuiI7m34Ms34oaDhmNaCiRNQdbsQANucBk24ycg0Am412ybg3bpu0GNAFz+2duO7JAzGJhoPkFcmYoGS2nDRzwyZNjHzrKfxhVBKgh/ogZLux/iu5oGqHNf5YGUkk

vYxcmbPu4FKT/iQbb2VKnpiKB7ysoFIq6gSij6wWgfIHQSb7jGxEK8ijAH9Gw3teoPUgQDQqUAKpvereS/PlDqGBLLJLrYBn6j0zOAw0PQDMAmgDcC3wXwB8CIQGqMoCaA2APQCVkLwBQG467QFh6Ji+3owHSuqDjr4PGZIKqCUsDKqyyGg1voVJDwl4AH57Em5EIgGYLfiaAwE0cgbLoka+MviGYn0OIFUOTvlIHkkdFl95M0+mDNJ9yc8jqZIi

y0vrBcqJ2DypCenDiDxFMZsvdTGBcfq/qqsnzpD6+2ynvEbhu0moQbPSm9sMEnuUKi8qrK5ykJBG2bSiOKQykKruZHuJQM/KIyJKjSx/kOYEJDMqiqPiq4y2Ko3J9KrKuTKlWWyuRI0yl6HqD0a4SmGo1quav2rhKPMg+78yrloZx+SIsgqHiyXHEmbIoxYDLJsK8sorJ8gyspiJN+u8GKHayuynrIHKhskJAmyrUObLTAlstmBQq9suTAOcamKn

aA+QkDCqey8KvqDui/srvZDBwMrmA6uy8vX4RyObAFjRy7BI+BxynSo2qFhwocDK5u6clKApg2cjqroyecgSSFybcqbxQqOTAkDbyVcobReQdcofLPyICqfLgK7ckOpdyU8j3Ieu/cvPKbg1IcPJ0hY8gWFnu38guFkhs8gtKdhYAIvJssacuVxryvfnOHfyW8pXK7yY4a06rhk4SfJgK78gOE3yaKn/IGYACk/KNyT4W/IQK7odfKNW+XGTCfhA

wt+EvyoCn+Gzh4ARKZj2LQcuptBU9sJKAom6ggDbqGCoiD5OOCjuroKJ6qry4AHPi+ZUKWwZ4B3+PPjm71OqAVDpXs8wOAqnBgFhQDgQ/QH8ArGh6sHAvAizFeCYAi4NgBMQw0LP5DOrpmYwRWHpgVI/BOHpK7/Bh3oCGyuCGqCHp8IQccFQh8rhjLW+xDjUqNBITJIwtKGqL+LL4v0oMI82lDmx74h6ZtIEJMxIVKitqPih2r+KZvuKwMMvajOo

NqbGjSz/Kj3iD47cvFuD6WB3ITYEZ+ABkqbZ+0/HnpFoD/ilyvSIwQBHlKyyqMpnKtSj96ih0UdcqH2MoR0oJyO5peGNAWoaTIdAgymeYnKEoe8obKyUVMqxgMyhVxrsCyrKrihYysVETKpUVsrhhIgZGGBhgJjVGxRrymsofKyYTGBMYQuA8p5Rd7rVHxR6yg1FZRJQDqDJAfyjg776fIBN6yq0oWCpyhW4W/6NA2YbSpUweYT4qLKKKr/IgRrc

u3zYqyJAaE4yoFHe7Eq9amSqjAFKnO4TRR4d9K0q8wPSpeQTKvqEsqZ0eyqNRR4ZyrMcG4byqyq8qubzOqyqmKpxAgag2AJqbkQ6p5RwMUqomqqqmqBtynQMqBaqs3u/5AxgqvDGuqYqokBjyNqlGB2qh4XqqwxWMUaqgx30aWK1qPqlzJ0G7/rGq0RkMWqGOcYaoxj0c6oFGqK2sqgzHxqzMaGqUxMYGmptQjCMGFDKTkTTH2hYoSWpCIQiPCLx

glajWhTq1MXmoDqDYduEToI6jZF+KE6kirOA4sSrGSx30YOjWR7atrE9+usfrF2hc6reawRR/quqn+09ihFj2W6keqYRe6oz6HqOEeEB4RHBpoCERI3k5bkRqACAGMuBbtq6vk9EQabCAJpsNDsQDwPkGCRuUiJEYenpmr50BZUlr5i2x3qwGnewynzIWhfxt7LYWT6LrRUyEPMWCUGgyvly4hJkZIFmRhIRc5u+eOAyoIyXss1CzANBEx7Fm4th

1aDcZspnJGBpIiYEchAjhD4+2/kX7Z8hqnvD6SOiPiMBaeS/Dp7v4ELtY62OiTsV6BewXqF4eE1nnY6eOtXso6xeeSF9QqO0QntYhCPIOV4XxujuwJfUeSJvzrxUNso57WG/NEQeEaIBvyAAdh4FIy9B4TYCiOBfF5IjAm54teSlhICrxPnrV4bxh/KV7lelXnvFReqAIfENeJ8co5nxmABfFXxd/N/zQCt8Z9T3xG/I/F7Wz8ZgCvxjhO/FfxP8

X/FYCACdglAJICRj4R4rPMl74+qXii5E+LgmT7ZegvLl5eea8b56OOmjpvFleIXhV5heVnggn2em1sglxeHAKgnoJmCaInXxuCWwJ3xHAA/ECJRnpgAkJZCQ4QUJ38b/H/xMAIAkcAwCTT4mWeTu7EFOzPujas+9XMobY2Q3vAGOWIOv+41OVBMSLAe5UOnyjiarnN5U2C3ooykAx4MQDyQcADNxWsicYorJxW3uoZpxsVhr6SRWivh5zOLAZTpU

yvJFR7txwiJrQEOEKKqBUwVcpRKuqPHDXF58RrtRYfeMgdRoq4iUWw43O/3snbvKO0qVYkisPMPFu2PkSn5dminmNa/OsPkSYzx6nlJbAuMlmC7LxFPM16S8MLvkbyWUyczyr871inApebiWl4cJOllwlYGlPutoSAICdMl0+SNmZbY0JLhjb1c9AalANCONhU7P2N6rsGdWL7HS5PqtnDXJm28OvN4dOgDugAWgUAGiCSAFwExDcgRxsJEwOzHn

A7xJAtoklk4mccwFBmJ3sR5ncgsW6LL4C5CaS6Bd3EyxqgsOsL5TACcvvBlJ9YjQ4Zmn3k3G+U8MgZg1oZavmJdCSIqJ6MhvAKMBzkQvr1ZDx7IZ0nzmXIePFKeoblPG3SanscRAuLIAvGZGS8bbrHAX1GZ5qOGCdglKJdCaYng23/CpqI4y9GvTf8Z1mokeak2pdai84qWV6Sp18bQlWEPIEAnypHhIqkwAyqaqmnW6qZqlvWxRkE5sJhPrJiVG

JPtUbcJ5RLwnapn1BKnnx0qQalGpcqQIkKpSqSqnPW1qch5tehye9rWJaNkrx2JRCvwwXJg3s1zrBP7oHFuJ+vIbTE29ancoqgK4UsD/2HyYt7DQ3ECsCEAw0JIArCnwZFZ46tAQkn0BSSXtwpJh3ClZEe+vuHz3kWrrNLgK0YHknVgJsumogBu8Mao0BaBAa4SBFSbrZ86xKbIFrc0Jg5HsktzicDN8+bgJgS6nkfFbeR7KYI44m6fpPF/O08Y4

FE8BPLwAgu2noXS6enqWbp4ufGlj4SAVumY7Xpo3nanVOayU6nE+EAKT5QMtRh6m+6V6RYktGVicclFOpLveb1c2wP7EbBwxnclWyjLjqDN+bBJHGfJEAPED6ALaA8BLGkgPQC9oGUg8BogSQIhCaAEwJgCY6KHkJHIswrqCmiuPNuK6QpCVimIwpLaXCltprwjGAfMiqNNKAEazr2nZmtwtIyMGqfHspAmAIlSTveU6dUktiaGJTB4kLGFW4ooo

FIxZtWhvuMCPo2IRW5MO/UqxbfQukdZj8k3Fv1abpnIdulp+UPnukDJ4jkMlOBZJhIC9MupPyL6krpEqCLMxAAZg2kLUDWhOs8QEeg8gCAIB64A36obTbApZpWojMPJsKY6iG9lsrimlyqBlEKkSaoRmi/nBaJOJ1yYqZppzovQpgUjLjRIEwNtn/Z6mhaYoxjA+ALxCAwxAiRkumScSCmWMmHuCkIOErlClSR2vrJHoWdUmvjWc7FpRKYyNYMWL

0YFtkFRbRUPI2APk+KaCYmuRKeJmC6htDxj0aYFBWbqoCmQwyCIbGg+zFghtIc7BGLKaibx+hmWPFCOJmbyH7pvKRZlHp8/EKko+F6VUjN0gAL8BgABXGgAF+Km9IAA3cnEiAAK9bL0G/P9papl2bdkPZz2W9kfZSXssmsJqyewlvpnCV+nA2P6ccDXZ92U9mvZ72Z9mI2pllGlAZ32iBmQBn4BGCOJyadODgADMJ+BwAcAJCBxoMbm+BUgmQDhh

fggUN0AMAhAAgCkoomS4bbAzOSzlAgH6SICGobYBsD6AkIKOkO+2tuznfgMnNzn6QjOS74WRSbBznC5GQNFKoewKaM6C5nOdzm85q3NQE05IEkLnoSyubWkQp23IrnS5IDg1nJJJPlLla5GQExBZx6uablQAXOTLlnpSmvrlm5+gB8BzxhPIUCO5NudzmVIz6Wzka5SuRkDE5okr0GGsHubbn6Ai4IvZ4Gl/rf6+51uWHmz2pwNtgDgbOcwDnMYI

Oz5LOBoOVEG0zCMFQ+W7uanmogYILBiBUUmesw/kEuhnyZ8EAEYBsABgKTk9ABAC3C76ssoOh7MuUKHnc5p4K/pombOe6AkAx6WKQkiA+RsApsUKMPnEANwGwBzoEeUybBAPohPli4c8PpCWgg0KQDPBuAGQIYB5mtvn0ph8GBJjAlAjSD1wwLGPa6o6+S6Bb5UurwDX5tEeZq52R+XGQfpOqMNA+kXnO7Yd5fucjAq5GIBbnxwnAINbAg48PXAJ

QhcI27hcKyJoDz5KOeuhEAKbCHqQAKyBTlYR4qDXDtwUaU/l2AiEMmTMA4DtRxT5M+ZAXQFC3p+DVAhAIwBrCloA3k3JS6cEBkF4KEXgFotcPoCJ5E+PyGhRcESHBkFFBXXkMoTieABSQD1KCDexmHLjnTgQAA==
```
%%